import { Provider } from '@ethersproject/abstract-provider';
import { Signer } from '@ethersproject/abstract-signer';
import type { BigNumber } from 'ethers';
import { ethers } from 'ethers';
import type { AddressLike, NumberLike, ProviderLike, SignerOrProviderLike, TransactionLike } from '../interfaces';
export declare const toSignerOrProvider: (signerOrProvider: SignerOrProviderLike) => Signer | Provider;
export declare const toProvider: (provider: ProviderLike) => Provider;
export declare const toJsonRpcProvider: (provider: ProviderLike) => ethers.providers.JsonRpcProvider;
export declare const toTransactionHash: (transaction: TransactionLike) => string;
export declare const toBigNumber: (num: NumberLike) => BigNumber;
export declare const toNumber: (num: NumberLike) => number;
export declare const toAddress: (addr: AddressLike) => string;
